<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-28 14:17
 */
interface ProjectexchmaterialDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Projectexchmaterial 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param projectexchmaterial primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Projectexchmaterial projectexchmaterial
 	 */
	public function insert($projectexchmaterial);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Projectexchmaterial projectexchmaterial
 	 */
	public function update($projectexchmaterial);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySerilno($value);

	public function queryByProjectid($value);

	public function queryByStoreid($value);

	public function queryByProjdate($value);

	public function queryBySysdate($value);

	public function queryByTotalnum($value);


	public function deleteBySerilno($value);

	public function deleteByProjectid($value);

	public function deleteByStoreid($value);

	public function deleteByProjdate($value);

	public function deleteBySysdate($value);

	public function deleteByTotalnum($value);


}
?>